;
; by Danilo, 04.07.03
;
;   fixed, 04.01.2004
;     - DIM array(10,10) creates array(11,11) in PB - arfff!
;     - SetMeshData() bug found
;
;   added, 05.01.2004
;     - rotating cube
;     - borders
;
Structure _Vertex 
  x1.f ; Vertex 1 
  y1.f 
  z1.f 
  x2.f ; Vertex 2 
  y2.f 
  z2.f 
  x3.f ; Vertex 3 
  y3.f 
  z3.f 
  x4.f ; Vertex 4 
  y4.f 
  z4.f 
EndStructure 

Structure _Triangles 
  Triangle_1_a.w ; Triangle 1 
  Triangle_1_b.w 
  Triangle_1_c.w 
  Triangle_2_a.w ; Triangle 2 
  Triangle_2_b.w 
  Triangle_2_c.w 
EndStructure 

Structure _TextureCoordinates 
  Vertex1_a.f ; Vertex 1 
  Vertex1_b.f 
  Vertex2_a.f ; Vertex 2 
  Vertex2_b.f 
  Vertex3_a.f ; Vertex 3 
  Vertex3_b.f 
  Vertex4_a.f ; Vertex 4 
  Vertex4_b.f 
EndStructure 

; 65.000 vertices = MAX ALLOWED!
;
; 127 x 127 = 16.129
;             16.129 * 4 corners = 64.516 vertices, thats OK ;)
;
#X_COUNT = 127
#Z_COUNT = 127

; 3 arrays for the ground generation
Dim Vertices._Vertex(#Z_COUNT,#X_COUNT-1)
Dim Triangles._Triangles(#Z_COUNT,#X_COUNT-1)
Dim TextureCoordinates._TextureCoordinates(#Z_COUNT,#X_COUNT-1)

If InitEngine3D() And InitSprite() And InitKeyboard() And InitMouse()

  OpenWindow(0,0,0,800,600,#PB_Window_SystemMenu|#PB_Window_ScreenCentered,"3D Mesh Test") 
  If OpenWindowedScreen(WindowID(),0,0,800,600,0,0,0)=0
    MessageRequester("ERROR","Cant open DirectX screen !",#MB_ICONERROR):End
  EndIf

  ; font for cube texture
  BigFont = LoadFont(1,"Arial",40) 
  SmallFont = LoadFont(2,"System",8)

  For x = 0 To #X_COUNT-1
    For z = 0 To #Z_COUNT-1 
      Vertices(z,x)\x1 = x 
      Vertices(z,x)\y1 = 0
      Vertices(z,x)\z1 = z 

      Vertices(z,x)\x2 = x+1 
      Vertices(z,x)\y2 = 0
      Vertices(z,x)\z2 = z 

      Vertices(z,x)\x3 = x+1 
      Vertices(z,x)\y3 = 0 
      Vertices(z,x)\z3 = z+1 

      Vertices(z,x)\x4 = x 
      Vertices(z,x)\y4 = 0 
      Vertices(z,x)\z4 = z+1 
      
      Triangles(z,x)\Triangle_1_a = Triangle_Counter+2 
      Triangles(z,x)\Triangle_1_b = Triangle_Counter+1 
      Triangles(z,x)\Triangle_1_c = Triangle_Counter 
      Triangles(z,x)\Triangle_2_a = Triangle_Counter 
      Triangles(z,x)\Triangle_2_b = Triangle_Counter+3 
      Triangles(z,x)\Triangle_2_c = Triangle_Counter+2 
      Triangle_Counter + 4 

      TextureCoordinates(z,x)\Vertex1_a = 0.0 
      TextureCoordinates(z,x)\Vertex1_b = 0.0 

      TextureCoordinates(z,x)\Vertex2_a = 1.0 
      TextureCoordinates(z,x)\Vertex2_b = 0.0 

      TextureCoordinates(z,x)\Vertex3_a = 1.0 
      TextureCoordinates(z,x)\Vertex3_b = 1.0 

      TextureCoordinates(z,x)\Vertex4_a = 0.0 
      TextureCoordinates(z,x)\Vertex4_b = 1.0 

    Next 
  Next 


    CreateMesh(0) 
    SetMeshData(0,#PB_Mesh_Vertices     ,Vertices()          , #X_COUNT*#Z_COUNT*4) 
    SetMeshData(0,#PB_Mesh_Triangles    ,Triangles()         , #X_COUNT*#Z_COUNT*2) 
    SetMeshData(0,#PB_Mesh_UVCoordinates,TextureCoordinates(), #X_COUNT*#Z_COUNT*4) 
    ;SetMeshData(0,#PB_Mesh_Normals      , ?Normalz           , 4) ; DOESNT WORK in PB 3.81
    ;SetMeshData(0,#PB_Mesh_Colors       , ?Colorz            , 4) ; DOESNT WORK in PB 3.81

    ; make ground texture
    CreateTexture(0,128,128)
    StartDrawing(TextureOutput(0)) 
      Box(0,0,128,128,$FF9090)
      DrawingMode(4)
      Box(0,0,128,128,$00FF00) 
      Box(1,1,126,126,$00FF00) 
      Box(2,2,124,124,$00FF00) 
    StopDrawing() 

    ; create ground entity
    CreateEntity(0,MeshID(0),CreateMaterial(0,TextureID(0))) 
    ScaleEntity( 0,2,2,2)


    ; create cube texture
    z=0
    CreateTexture(1,512,512) 
    StartDrawing(TextureOutput(1)) 
      Box(0,0,512,512,$8000FFFF)
      DrawingMode(1)
      DrawingFont(BigFont)
      For b = 0 To 500 Step 128
        For a = 0 To 500 Step 128
          z+1
          Line(a,b,128,128,$000000)
          Line(a+128,b,-128,128,$000000)
          Locate(a+64-TextLength(Str(z))/2,b+35)
          FrontColor($00,$00,$FF)
          DrawText(Str(z)+".")
        Next a
      Next b
    StopDrawing() 

    ; set cube mesh data
    CreateMesh(1)
    SetMeshData(1,#PB_Mesh_Vertices     ,?CubeVertices          ,6*4)
    SetMeshData(1,#PB_Mesh_Triangles    ,?CubeFacesIndexes      ,6*2)
    SetMeshData(1,#PB_Mesh_UVCoordinates,?CubeTextureCoordinates,6*4)

    ; create cube entity
    CreateEntity(1,MeshID(1),CreateMaterial(1,TextureID(1)))
    ScaleEntity(1, 10, 10, 10)
    EntityLocate(1,150,20,150)
    RotateEntity(1,180,0,0)


    ; create 4 borders
    Restore BorderColors
    For a = 0 To 3
      CreateMesh(2+a)
      SetMeshData(2+a,#PB_Mesh_Vertices     ,?BorderVertices          ,4)
      SetMeshData(2+a,#PB_Mesh_Triangles    ,?BorderFaces             ,2)
      SetMeshData(2+a,#PB_Mesh_UVCoordinates,?BorderTextureCoordinates,4)
      CreateTexture(2+a,256,256)
      StartDrawing(TextureOutput(2+a))
        Read color
        Box(0,0,256,256,color)
        If a<>1
          Locate(5,170)
          DrawingMode(1)
          FrontColor($FF-Red(color),$FF-Green(color),$FF-Blue(color))
          DrawingFont(BigFont)
          DrawText("PureBasic")
        EndIf
      StopDrawing()
      CreateEntity(2+a,MeshID(2+a),CreateMaterial(2+a,TextureID(2+a)))
      ScaleEntity(2+a,255,50,0)
    Next a

    ; border 1
    RotateEntity(2,180,0,0)
    EntityLocate(2,0,-5,0)
    ; border 2
    RotateEntity(3,180,180,0)
    EntityLocate(3,0,45,254)
    ; border 3
    RotateEntity(4,-90,0,0)
    EntityLocate(4,0,-5,254)
    ; border 4
    RotateEntity(5,90,0,00)
    EntityLocate(5,254,-5,0)


    ; create and initialize camera
    CreateCamera(0, 0,  0, 100, 100) 
    CameraLocate(0, 150, 4, 220)
    RotateCamera(0, 0, -10, 0) 

    ; GO!
    Repeat 
      ExamineKeyboard() 
      Select WindowEvent()
        Case #PB_Event_CloseWindow 
          Quit = #TRUE
      EndSelect

      ; movement with keys
      If     KeyboardPushed(#PB_KEY_RIGHT)
        MoveCamera(0, 1,0,0)
      ElseIf KeyboardPushed(#PB_KEY_LEFT)
        MoveCamera(0,-1,0,0)
      ElseIf KeyboardPushed(#PB_KEY_UP)
        MoveCamera(0,0,0,-3)
      ElseIf KeyboardPushed(#PB_KEY_DOWN)
        MoveCamera(0,0,0, 3)
      EndIf
      
      ; collision detection for the room borders
      If CameraY(0) <   4: CameraLocate(0,CameraX(0),  4,CameraZ(0)) : EndIf
      If CameraY(0) >  40: CameraLocate(0,CameraX(0), 40,CameraZ(0)) : EndIf
      If CameraX(0) <   4: CameraLocate(0,  4,CameraY(0),CameraZ(0)) : EndIf
      If CameraX(0) > 250: CameraLocate(0,250,CameraY(0),CameraZ(0)) : EndIf
      If CameraZ(0) <   4: CameraLocate(0,CameraX(0),CameraY(0),  4) : EndIf
      If CameraZ(0) > 250: CameraLocate(0,CameraX(0),CameraY(0),250) : EndIf
      
      ; rotate da cube
      RotateEntity(1,0.5,-1,0.1)
      
      ; mouse freelook
      ExamineMouse()
      RotateCamera(0,-MouseDeltaX(),-MouseDeltaY(),0)

      ; animate ground texture
      StartDrawing(TextureOutput(0))
        Box(3,3,122,122,RGB(textcol1,textcol1,textcol1*2))
      StopDrawing()
      If textcol1_flag
        textcol1-2
        If textcol1=<  0 : textcol1_flag = #FALSE : textcol1 =   0 : EndIf
      Else
        textcol1+2
        If textcol1=>100 : textcol1_flag = #TRUE  : textcol1 = 100 : EndIf
      EndIf

      ; show it
      ;ClearScreen(0,0,0)
      RenderWorld() 
      FlipBuffers() 
    Until KeyboardPushed(#PB_Key_Escape) Or Quit 
Else 
  MessageRequester("Error", "Cant init DirectX 3D Engine",0) 
EndIf 
  
End 

DataSection

  CubeVertices:
    Data.f  1, 1,-1 ; Vertex 0
    Data.f -1, 1,-1 ; Vertex 1
    Data.f  1,-1,-1 ; Vertex 2
    Data.f -1,-1,-1 ; Vertex 3

    Data.f  1, 1, 1 ; Vertex 4
    Data.f -1, 1, 1 ; Vertex 5
    Data.f  1, 1,-1 ; Vertex 6
    Data.f -1, 1,-1 ; Vertex 7

    Data.f  1,-1, 1 ; Vertex 8
    Data.f -1,-1, 1 ; Vertex 9
    Data.f  1, 1, 1 ; Vertex 10
    Data.f -1, 1, 1 ; Vertex 11

    Data.f  1,-1,-1 ; Vertex 12
    Data.f -1,-1,-1 ; Vertex 13
    Data.f  1,-1, 1 ; Vertex 14
    Data.f -1,-1, 1 ; Vertex 15

    Data.f  1, 1, 1 ; Vertex 16
    Data.f  1, 1,-1 ; Vertex 17
    Data.f  1,-1, 1 ; Vertex 18
    Data.f  1,-1,-1 ; Vertex 19

    Data.f -1, 1,-1 ; Vertex 20
    Data.f -1, 1, 1 ; Vertex 21
    Data.f -1,-1,-1 ; Vertex 22
    Data.f -1,-1, 1 ; Vertex 23


  CubeFacesIndexes:
    Data.w  0, 2, 1 ; front
    Data.w  1, 2, 3

    Data.w  4, 6, 5 ; top
    Data.w  5, 6, 7

    Data.w  8,10, 9 ; back
    Data.w  9,10,11

    Data.w 12,14,13 ; bottom
    Data.w 13,14,15

    Data.w 16,18,17 ; left
    Data.w 17,18,19

    Data.w 20,22,21 ; right
    Data.w 21,22,23

  CubeTextureCoordinates:
    Data.f 0.00 , 0.00 ; '1' = front
    Data.f 0.25 , 0.00
    Data.f 0.00 , 0.25
    Data.f 0.25 , 0.25

    Data.f 0.25 , 0.00 ; '2' = top
    Data.f 0.50 , 0.00
    Data.f 0.25 , 0.25
    Data.f 0.50 , 0.25

    Data.f 0.50 , 0.00 ; '3' = back
    Data.f 0.75 , 0.00
    Data.f 0.50 , 0.25
    Data.f 0.75 , 0.25

    Data.f 0.75 , 0.00 ; '4' = bottom
    Data.f 1.00 , 0.00
    Data.f 0.75 , 0.25
    Data.f 1.00 , 0.25

    Data.f 0.00 , 0.25 ; '5' = left
    Data.f 0.25 , 0.25
    Data.f 0.00 , 0.50
    Data.f 0.25 , 0.50

    Data.f 0.25 , 0.25 ; '6' = right
    Data.f 0.50 , 0.25
    Data.f 0.25 , 0.50
    Data.f 0.50 , 0.50

  BorderVertices:
    Data.f  0,1,0 ; Vertex 0
    Data.f -1,1,0 ; Vertex 1
    Data.f  0,0,0 ; Vertex 2
    Data.f -1,0,0 ; Vertex 3
  BorderFaces:
    Data.w  0, 2, 1
    Data.w  1, 2, 3
  BorderTextureCoordinates:
    Data.f 0,0
    Data.f 1,0
    Data.f 0,1
    Data.f 1,1
  BorderColors:
    Data.l $FF0000
    Data.l $00FF00
    Data.l $FF00FF
    Data.l $FFFF00

;   Colorz: 
;     Data.f 0.0, 1.0 
;     Data.f 1.0, 0.2 
;     Data.f 0.0, 1.0 
;     Data.f 0.5, 1.0 
;   Normalz: 
;     Data.f -1.0, -1.0 
;     Data.f  1.0,  0.0 
;     Data.f -1.0,  0.0 
;     Data.f  1.0,  0.0
EndDataSection 

; ExecutableFormat=Windows
; Executable=SetMeshData 001.exe
; DisableDebugger
; EOF